# COPYRIGHT (C) ERICSSON AB, 2011
#
# 2011-11-22 eguanwu
#
# Script for OSS-RC to check if License Key CXC402 0009 CE UL and CXC4020046 CE DL installed on a node
#

from popen2 import Popen4
import re

SMOCPP = "/opt/ericsson/bin/smocpp"


SMO.reportTotal(5)

SMO.reportDetails("Retrieving LKF for " + SMO_NE_NAME + ".")
SMO.reportCount(1)

# Put the whole LKF in one long string. It should be
# more robust since LKF v2 is formatted as one long line (except the signature),
# and LKF v1 isn't.
output = "".join(Popen4(SMOCPP + " viewlickey -ne " + SMO_NE_NAME).fromchild)
SMO.reportDetails("Analyzing LKF for " + SMO_NE_NAME + ".")
SMO.reportCount(2)
SMO.reportDetails("output is " + output + ".")
SMO.reportCount(3)

if re.search("productType=\".*RBS.*\"", output):
    SMO.reportDetails("Checking Capacity Licenses!")
    key1 = False  #flag to detect key CXC4020009
    key2 = False  #flag to detect key CXC4020046
    if "capacityKey id=\"CXC4020009\"" in output:
        SMO.reportDetails("Capacity License CXC4020009 found on node.")
        key1 = True          # Found CXC4020009 key
    if "capacityKey id=\"CXC4020046\"" in output:
        SMO.reportDetails("Capacity License CXC4020046 found on node.")
        key2 = True          # Found CXC4020046 key
    if key1 and key2:
        SMO.reportDetails( "RBS Capacity Licenses found. Upgrade can continue!")
        SMO.reportCount(4)
    elif key1 == True and key2 == False:
        SMO.reportFailed("Please install Capacity License CXC4020009 before upgrading.License Validation Check failed!")
	SMO.reportCount(4)
    elif key1 == False and key2 == True:
        SMO.reportFailed(" Please install Capacity License CXC4020046 before upgrading. License Validation Check failed!")
	SMO.reportCount(4)
    else:
        SMO.reportFailed("Please install Capacity License Keys CXC4020009 and CXC4020046 before upgrading. License Validation Check failed!")
	SMO.reportCount(4)
else:
    SMO.reportDetails("No need to look for RBS Capacity keys.")
    SMO.reportCount(5)



